proc import datafile = "y:\desktop\projects 2009\yanai uncertainty\Whittaker.csv" out=whit replace;run;
data whit;set whit;if oldndls = -999 then oldndls = .;run;

data whit2;set whit;where (spec="ACSA" and z ne 1) ; run;

data whit2a;set whit2;loght=log10(ht);logdbh=log10(dbh);logtot=log10(totmass);run;

proc import datafile = "y:\desktop\projects 2009\yanai uncertainty\Plot Inventory ACSA BEAL FAGR.csv" out=plot replace;run;

data plot;set plot;where spec = "ACSA";
	logdbh=log10(dbh); run;
	

%macro strapper;
%do i =1 %to 1000;
 data whit3; 
 	%if &i = 1 %then %do;
      set whit2a (keep=dbh ht logdbh loght logtot); 
	%end;
	%else %do;
	_choice = int(ranuni(0)*n) + 1; 
     set whit2a (keep=dbh ht logdbh loght logtot) point=_choice nobs=n ; 
     j+1 ;
     if j > n then stop ; 
	%end;
run;

data whit3a;set whit3 plot;run;

proc nlin data = whit3a noprint;
	parms a1 = 1 b1 = 1;
	model logtot = a1 + b1*logdbh;	
	id a1 b1;
	output out=whit3b p=logpredtot;
	run;

data whit4;set whit3b;predtot=10**logpredtot/1000000;
run;

proc means data=whit4 noprint;where z = 0;
output out=iteration sum(PredTot) =  PredTot;
run;

proc append data=iteration base= summary;run;

%end;
%mend;


proc datasets nolist;delete iteration summary;run;

%strapper;

proc univariate data=summary;var predtot;histogram  predtot ;
run;

proc means data=summary  clm p1;run;

proc sort data=summary;by predtot;run;
data summary;set summary;nobs=_N_;run;
proc print data=summary;where nobs=25 or nobs=976;run;
